package main
import (
	"encoding/json"
	"net/http"
	"bytes"
	"time"
	"sync"
	"fmt"
	"io"
)

var (
	_image = []byte{}
	_baseUrl = "https://%s.eagleeyenetworks.com"
	_esn = "1006073b"
	_username = "<YOUR EMAIL>"
	_password = "<YOUR PASSWORD>"

	mutex = sync.Mutex{}
	img = []byte{}
)

//Check response
func checkResponse(resp *http.Response, err error) bool {
	if err != nil {
		fmt.Println(err)
		time.Sleep(time.Second * 10)
		return false
	} else if resp.StatusCode != 200 {
		if resp.Body != nil {
			resp.Body.Close()
		}

		fmt.Printf("Got status code '%d' for '%s' sleeping for 10 seconds\n", resp.StatusCode, resp.Request.URL.String())
		time.Sleep(time.Second * 10)
		return false
	}

	return true
}

func doRequest(method string, url string, contentType string, rdr io.Reader, cookies []*http.Cookie) (*http.Response, error) {
	req, err := http.NewRequest(method, url, rdr)
	if err != nil {
		return nil, err
	}

	if contentType != "" {
		req.Header.Set("Content-Type", contentType)
	}

	//Set cookies
	for _, c := range cookies {
		ncookie := *c
		ncookie.Domain = req.URL.Host
		req.AddCookie(&ncookie)
	}

	//Client
	client := http.Client{}
	return client.Do(req)
}

//Fetch the image
func fetchImage(esn string, username string, password string) {
	var cookies []*http.Cookie
	branded := "login"
	for {
		if cookies == nil {
			branded = "login"
			rdr := bytes.NewReader([]byte(fmt.Sprintf(`{"username":"%s","password":"%s"}`, username, password)))
			resp, err := http.Post(fmt.Sprintf(_baseUrl, branded) + "/g/aaa/authenticate", "application/json", rdr)
			if !checkResponse(resp, err) {
				continue
			}

			cookies = resp.Cookies()
			dresp := bytes.Buffer{}
			io.Copy(&dresp, resp.Body)
			resp.Body.Close()

			//Authorize
			ret := struct{ Token string   `json:"token"`
			               Branded string `json:"branded_subdomain,omitempty"` }{}

			json.Unmarshal(dresp.Bytes(), &ret)
			if ret.Branded != "" {
				branded = ret.Branded
			}

			//Marshal
			ret.Branded = ""
			buf, err := json.Marshal(&ret)
			if err != nil {
				fmt.Println(err.Error())
				fmt.Printf("Got status code '%d' sleeping for 10 seconds\n", resp.StatusCode)
				time.Sleep(time.Second * 10)
				continue
			}

			//New reader
			rdr = bytes.NewReader(buf)
			resp, err = doRequest("POST", fmt.Sprintf(_baseUrl, branded) + "/g/aaa/authorize", "application/json", rdr, cookies)
			if !checkResponse(resp, err) {
				continue
			}

			//Set cookies
			resp.Body.Close()
			cookies = resp.Cookies()
		}

		//Get image
		resp, err := doRequest("GET", fmt.Sprintf(_baseUrl + "/asset/next/image.jpeg?id=%s&timestamp=now&asset_class=all", branded, esn), "", nil, cookies)
		if resp.StatusCode == 401 || resp.StatusCode == 403 {
			cookies = nil
			fmt.Printf("got a %d", resp.StatusCode)
			panic("DEATH")
			continue
		} else if !checkResponse(resp, err) {
			continue
		}

		//Go the image
		mutex.Lock()
		fmt.Println("Got image")
		buf := &bytes.Buffer{}
		io.Copy(buf, resp.Body)
		img = buf.Bytes()
		fmt.Println("LEN: ", len(img))
		mutex.Unlock()
		resp.Body.Close()


		//Sleep one second before going to the next image
		time.Sleep(time.Second)
	}
}

//Serve the image
func serveImage(w http.ResponseWriter, req *http.Request) {
	path := req.URL.String()
	fmt.Println(path[1:9], len(path))
	if len(path) < 9 || path[1:9] != _esn {
		http.Error(w, "Invalid esn", 400)
	}

	mutex.Lock()
	b := img
	mutex.Unlock()

	w.Header().Add("Content-Type", "image/jpeg")
	w.Header().Add("Cache-Control", "no-cache, no-store, must-revalidate")
	w.Header().Add("Pragma", "no-cache")
	w.Header().Add("Expires", "0")
	w.Write(b)
}

func main() {
	go fetchImage(_esn, _username, _password)
	srv := http.Server{ Addr: "0.0.0.0:8080",
	                    Handler: http.HandlerFunc(serveImage), }

	srv.ListenAndServe()
}
