#/bin/env python
from gevent import monkey
monkey.patch_all()
from gevent.wsgi import WSGIServer
from flask import Flask, Response, make_response
import pprint
import requests
import gevent
import time
import io

app = Flask(__name__)
_BASE_URL = "http://{}.eagleeyenetworks.com"
_SHARED_IMG = None
_LOCK = gevent.lock.Semaphore()
_ESN = "1006073b"

def imageFetcher(esn, user, passwd):
    global _SHARED_IMG
    global _LOCK

    cookies = None
    branded = "login"
    while True:
        #No cookie authenticate
        if cookies == None:
            branded = "login"
            data = { "username": user,
                     "password": passwd, } 

            #Authenticate and Authorize
            resp = requests.post(_BASE_URL.format(branded) + "/g/aaa/authenticate", data = data)
            if resp.status_code == 200:
                data = resp.json()
                data = { "token": data['token'] }
                pprint.pprint(data)
                resp = requests.post(_BASE_URL.format(branded) + "/g/aaa/authorize", data)
                if resp.status_code == 200:
                    cookies = resp.cookies
                    rdata = resp.json()
                    if 'branded_subdomain' in rdata:
                        branded = rdata['branded_subdomain']
                else:
                    print "Got status code '{}' sleeping for 10 seconds".format(resp.status_code)
                    time.sleep(10.0)
                    continue
            else:
                print "Got status code '{}' sleeping for 10 seconds".format(resp.status_code)
                time.sleep(10.0)
                continue


        #Get image!
        url = "http://{}.eagleeyenetworks.com/asset/next/image.jpeg?id={}&timestamp=now&asset_class=all".format(branded, esn)
        print url
        resp = requests.get(url, cookies=cookies, stream=True)
        if resp.status_code == 200:
            print "GOT IMAGE"
            _LOCK.acquire()
            _SHARED_IMG = resp.raw.read(resp.headers.get('content-length'))
            print "LEN: {}".format(len(_SHARED_IMG))
            _LOCK.release()
            time.sleep(1.0)
        else:
            if resp.status_code == 401 or resp.status_code == 403:
                cookies = None
                print "Got a 401/403 resetting cookie"
                continue

            print "Got status code '{}' sleeping for 10 seconds".format(resp.status_code)
            time.sleep(10.0)
            continue

@app.route('/<esn>')
def getImage(esn):
    global _SHARED_IMG
    global _LOCK

    if esn == _ESN:
        _LOCK.acquire()
        data = _SHARED_IMG
        _LOCK.release()

        if data != None:
            resp = make_response(data)
            resp.headers['Content-Type'] = 'image/jpeg'
            resp.headers['Cache-Control'] = 'no-cache, no-store, must-revalidate'
            resp.headers['Pragma'] = "no-cache"
            resp.headers['Expires'] = "0"
            return resp

    return "IMAGE NOT FOUND", 404


if __name__ == "__main__":
    app.debug = True
    gevent.Greenlet.spawn(imageFetcher, _ESN, '<YOUR EMAIL>', '<YOUR PASSWORD>')
    http = WSGIServer(('', 8080), app)
    http.serve_forever()
